<?php
/**
 * Template Name: HYC Page
 * Template Post Type: page
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$background_image = ""; // Replace with your method to retrieve the image URL.
?>

<?php get_header(); ?>

<style>
    * {
        font-family: "Outfit";
    }
    /* Background and layout */
    .main-container {
        position: relative;
        min-height: 100vh;
        overflow: hidden;
        display: flex;
        flex-direction: row;
        background-size: cover;
    }

    .background-image {
        position: absolute;
        inset: 0;
        z-index: 2;
        object-fit: cover;
        height: 100%;
    }

    .rs-slider-container {
        position: absolute;
        inset: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        z-index: 11;
    }

    /* Overlay styles */
    .overlay-cyan {
        position: absolute;
        inset: 0;
        background-color: #164e63;
        opacity: 0.35;
        z-index: 3;
    }

    .overlay-black {
        position: absolute;
        inset: 0;
        background-color: black;
        opacity: 0.6;
        z-index: 4;
    }

    /* Sidebar styles */
    #sidebar {
        display: none;
        z-index: 50;
        width: 350px;
        background: rgba(88, 236, 255, 0.6);
        height: 100vh;
        color: black;
    }

    #sidebar-content {
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: space-between;
        padding-top: 2rem;
        padding-bottom: 1.5rem;
        padding-left: 1rem;
        padding-right: 1rem;
        height: 100%;
    }

    #toggle-collapse {
        position: absolute;
        color: white;
        top: 50%;
        right: -0.75rem;
        cursor: pointer;
    }

    .logo-img {
        width: 180px;
    }

    .sidebar-title {
        font-size: 1.5rem;
        font-weight: bold;
        padding-bottom: 2px;
        border-bottom: 2px solid black;
    }

    .menu-link {
        display: flex;
        flex-direction: column;
        color: black;
        text-transform: uppercase;
        font-weight: bold;
        font-size: 0.875rem;
        cursor: pointer;
    }

    .menu-link span {
        font-size: 1.475rem;
        cursor: pointer;
    }


    .menu-link .divider {
        border-bottom: 2px solid black;
        width: 2rem;
        height: 3px;
        border-radius: 10px;
        margin-top: 0.5rem;
        background: black;
        color: black !important;
    }

    .login-btn {
        display: flex;
        justify-content: center;
        color: white;
        background-color: #4c3182;
        border: 2px solid white;
        border-radius: 9999px;
        width: 120px;
        font-size: 0.875rem;
        font-weight: medium;
        margin-top: 1rem;
        padding: 2px;
    }

    .footer-text {
        font-size: 0.75rem;
    }

    /* Collapsed sidebar styles */
    #sidebar-content-collapsed {
        display: none;
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: space-between;
        padding-top: 2rem;
        padding-bottom: 1.5rem;
        padding-left: 1rem;
        padding-right: 1rem;
        height: 100%;
    }

    .favicon-img {
        width: 40px;
        height: auto;
    }

    .collapsed-footer-text {
        font-size: 0.5rem;
    }

    /* Main content */
    .main-content {
        flex-grow: 1;
        width: 100%;
        padding: 0.5rem;
        overflow: auto;
        max-height: auto;
        z-index: 2147483647;
    }

    @media (min-width: 1024px) {
        #sidebar {
            display: block;
        }

        .background-image {
            height: auto;
        }

        .main-content {
            max-height: 100vh;
        }
    }
</style>

<div class="main-container">
    <!-- Background overlay -->
    <?php if ($background_image) : ?>
        <img src="<?php echo esc_url($background_image); ?>" alt="Background" class="background-image">
    <?php endif; ?>

    <div class="rs-slider-container">
        <div id="rs-slider-slot">
            <!-- Slot for any dynamic content -->
        </div>
    </div>

    <div class="overlay-cyan"></div>
    <div class="overlay-black"></div>

    <!-- Sidebar -->
    <div id="sidebar">
        <input type="hidden" id="my_user_id" value="0">

        <!-- Expanded Sidebar Content -->
        <div id="sidebar-content">
            <button id="toggle-collapse">
                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30.33 25.27">
                    <g style="opacity: 0.65">
                        <rect style="fill: #e6e7e8" width="30.33" height="5.05"></rect>
                        <rect style="fill: #e6e7e8" y="10.11" width="30.33" height="5.05"></rect>
                        <rect style="fill: #e6e7e8" y="20.22" width="30.33" height="5.05"></rect>
                    </g>
                </svg>
            </button>
            <?php
            $custom_logo_id = get_theme_mod('custom_logo');
            $logo = wp_get_attachment_image_src($custom_logo_id, 'full');

            if (has_custom_logo()) {
                echo '<a href="' . esc_url(home_url('/')) . '">';
                echo '<img class="logo-img" src="' . esc_url($logo[0]) . '" alt="HYC Logo">';
                echo '</a>';
            } else {
                echo '<a href="' . esc_url(home_url('/')) . '">';
                echo '<img class="logo-img" src="/images/logo/landscape.png" alt="HYC Logo">';
                echo '</a>';
            }
            ?>

            <div class="flex flex-col items-center gap-10 w-full">
                <span class="sidebar-title"><?php the_title(); ?></span>

                <div class="flex flex-col gap-2 w-full pl-10">
                    <?php
                    // Get the sidebar menu by location
                    $menu_location = 'sidebar-menu';
                    $locations = get_nav_menu_locations();

                    if (isset($locations[$menu_location])) {
                        $menu_id = $locations[$menu_location];
                        $menu_items = wp_get_nav_menu_items($menu_id);

                        if (!empty($menu_items)) {
                            foreach ($menu_items as $menu_item) {
                                echo '<a href="' . esc_url($menu_item->url) . '" class="menu-link">';
                                echo esc_html($menu_item->title);
                                echo '<div class="divider"></div>';
                                echo '</a>';
                            }
                        }
                    } else {
                        echo '<p class="text-sm">Please assign a menu to the Sidebar Menu location.</p>';
                    }
                    ?>
                    <a href="/login" class="login-btn">LOGIN</a>
                </div>
            </div>

            <div class="flex flex-col items-center gap-1">
                <span class="footer-text">© 2022, HYC Association</span>
            </div>
        </div>

        <!-- Collapsed Sidebar Content -->
        <div id="sidebar-content-collapsed">
            <button id="toggle-collapse">
                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30.33 25.27">
                    <g style="opacity: 0.65">
                        <rect style="fill: #e6e7e8" width="30.33" height="5.05"></rect>
                        <rect style="fill: #e6e7e8" y="10.11" width="30.33" height="5.05"></rect>
                        <rect style="fill: #e6e7e8" y="20.22" width="30.33" height="5.05"></rect>
                    </g>
                </svg>
            </button>
            <?php
            $site_icon_url = get_site_icon_url(40);
            if ($site_icon_url) {
                echo '<a href="' . esc_url(home_url('/')) . '">';
                echo '<img class="favicon-img" src="' . esc_url($site_icon_url) . '" alt="Site Icon">';
                echo '</a>';
            } else {
                echo '<a href="' . esc_url(home_url('/')) . '">';
                echo '<img class="favicon-img" src="/images/favicon.png" alt="Site Icon">';
                echo '</a>';
            }
            ?>

            <div class="flex flex-col gap-2 w-full items-center">
                <?php
                // Get the sidebar menu by location
                $menu_location = 'sidebar-menu-collapsed';
                $locations = get_nav_menu_locations();

                if (isset($locations["sidebar-menu-collapsed"])) {
                    $menu_id = $locations["sidebar-menu-collapsed"];
                    $menu_items = wp_get_nav_menu_items($menu_id);

                    if (!empty($menu_items)) {
                        foreach ($menu_items as $menu_item) {
                            echo '<a href="' . esc_url($menu_item->url) . '" class="menu-link ">';
                            echo '<span style="width: 18px; height: 18px;" class="iconify" data-icon="' . esc_html($menu_item->title) . '" data-inline="false"></span>';
                            echo '</a>';
                        }
                        
                    }
                } else {
                    echo '<p class="text-sm">Please assign a menu to the Sidebar Menu location.</p>';
                }
                ?>
            </div>

            <div>
                <span class="collapsed-footer-text">© HYC</span>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <?php
        // WordPress Loop for dynamic content
        while (have_posts()) : the_post();
            the_content();
        endwhile;
        ?>
    </div>

    <script>
        let collapsed = false;

        document.querySelectorAll("#toggle-collapse").forEach(button => {
            button.addEventListener("click", () => {
                const sidebar = document.getElementById("sidebar");
                const contentExpand = document.getElementById("sidebar-content");
                const contentCollapsed = document.getElementById("sidebar-content-collapsed");

                if (!collapsed) {
                    gsap.to(contentExpand, {
                        opacity: 0,
                        duration: 0.1,
                        onComplete: () => {
                            contentExpand.style.display = "none";
                            contentCollapsed.style.display = "flex";
                            gsap.to(sidebar, {
                                width: "60px",
                                duration: 0.3,
                                ease: "power2.inOut",
                                onComplete: () => {
                                    gsap.to(contentCollapsed, { opacity: 1, duration: 0.3 });
                                }
                            });
                            collapsed = true;
                        }
                    });
                } else {
                    gsap.to(contentCollapsed, {
                        opacity: 0,
                        duration: 0.1,
                        onComplete: () => {
                            contentCollapsed.style.display = "none";
                            contentExpand.style.display = "flex";
                            gsap.to(sidebar, {
                                width: "350px",
                                duration: 0.3,
                                ease: "power2.inOut",
                                onComplete: () => {
                                    gsap.to(contentExpand, { opacity: 1, duration: 0.3 });
                                }
                            });
                            collapsed = false;
                        }
                    });
                }
            });
        });
    </script>

</div>

<?php get_footer(); ?>
